## This file (sage-slides.sagetex.sage) was *autogenerated* from sage-slides.tex with sagetex.sty version 2010/10/20 v2.3.
import sagetex
_st_ = sagetex.SageTeXProcessor('sage-slides')
_do_ver_check_ = True
if _do_ver_check_ and sagetex.__version__.find('2010/10/20 v2.3') == -1:
 import sys
 print '{0}.sage was generated with sagetex.sty version 2010/10/20 v2.3,'.format( sys.argv[0].split('.')[0])
 print 'but is being processed by sagetex.py version {0}.'.format( ' '.join(sagetex.__version__.strip().strip('[').split()[0:2]))
 print 'SageTeX version mismatch! Exiting.'
 sys.exit(int(1))
_st_.blockbegin()
try:
 from sage.graphs.graph_latex import setup_latex_preamble
 setup_latex_preamble()
except:
 _st_.goboom(86)
_st_.blockend()
try:
 _st_.inline(0, latex(factor(2010)))
except:
 _st_.goboom(10)
try:
 _st_.plot(0, format='notprovided', _p_=plot(-x^3+3*x^2+7*x-4,(x,-5,5)))
except:
 _st_.goboom(10)
_st_.blockbegin()
try:
 f(x,y)=x*sin(y); grad_f=f.gradient()
except:
 _st_.goboom(16)
_st_.blockend()
try:
 _st_.inline(1, latex(f(x,y)))
except:
 _st_.goboom(17)
try:
 _st_.inline(2, latex(grad_f(x,y)))
except:
 _st_.goboom(18)
try:
 _st_.plot(1, format='notprovided', _p_=plot_vector_field(grad_f, (x,-3,3), (y,0,3)), frame=True, aspect_ratio=1)
except:
 _st_.goboom(20)
_st_.blockbegin()
try:
 m=identity_matrix(QQ,3)
 m[0]=m[0]+m[1]
 m[1]=m[1]-m[2]
 m[2]=m[2]-2*m[1]
 m[1]=m[1]+3*m[0]
 m[0]=2*m[0]
except:
 _st_.goboom(23)
_st_.blockend()
try:
 _st_.inline(3, latex(m))
except:
 _st_.goboom(24)
_st_.blockbegin()
try:
 M=random_matrix(QQ,3,4,algorithm='echelonizable',
     rank=2, upper_bound=10)
except:
 _st_.goboom(16)
_st_.blockend()
try:
 _st_.inline(4, latex(M))
except:
 _st_.goboom(17)
try:
 _st_.inline(5, latex(M.rref()))
except:
 _st_.goboom(18)
_st_.blockbegin()
try:
    f(x,y)=2*x^2*y+x*sec(y)+e^(-2*y)
    resolution = 10
    slope_field=plot_slope_field(-diff(f,x)/diff(f,y), (x,-3,3),(y,-2,3.5),
       plot_points=resolution)
    phase=sum([implicit_plot(f(x,y)+i,(x,-3,3),(y,-2,3.5),
       plot_points=resolution*20, cmap='bone') for i in [-22..22,step=2]])
   
except:
 _st_.goboom(8)
_st_.blockend()
try:
 _st_.plot(2, format='notprovided', _p_=slope_field+phase, aspect_ratio=1, figsize=(5,5))
except:
 _st_.goboom(11)
try:
 _st_.inline(6, latex(diff(f(x,y),x)))
except:
 _st_.goboom(19)
try:
 _st_.inline(7, latex(diff(f(x,y),y)))
except:
 _st_.goboom(19)
_st_.blockbegin()
try:
 f(x,y)=x*sin(y)+y*cos(x)
except:
 _st_.goboom(14)
_st_.blockend()
try:
 _st_.plot(3, format='notprovided', _p_=plot3d(f,(x,-2,2),(y,-2,2)))
except:
 _st_.goboom(15)
_st_.blockbegin()
try:
 mathematica('myplot=Plot3D[x^2-y^2,{x,-1,1},{y,-1,1}]')
 mathematica('Export["%s/graphicsfile.pdf", myplot]' % os.getcwd())
except:
 _st_.goboom(16)
_st_.blockend()
_st_.blockbegin()
try:
   G=graphs.PetersenGraph()
   P=G.coloring()
except:
 _st_.goboom(16)
_st_.blockend()
try:
 _st_.inline(8, latex(G.chromatic_number()))
except:
 _st_.goboom(20)
try:
 _st_.plot(4, format='notprovided', _p_=G.plot(partition=P))
except:
 _st_.goboom(22)
_st_.blockbegin()
try:
     g = graphs.PetersenGraph()
     g.set_latex_options(tkz_style = 'Shade')
   
except:
 _st_.goboom(13)
_st_.blockend()
try:
 _st_.inline(9, latex(g))
except:
 _st_.goboom(14)
_st_.blockbegin()
try:
 H=graphs.HeawoodGraph()
 H.set_latex_options(
  graphic_size=(4,4),
  vertex_size=0.2,
  edge_thickness=0.04,
  edge_color='green',
  vertex_color='green',
  vertex_label_color='red')
except:
 _st_.goboom(28)
_st_.blockend()
try:
 _st_.inline(10, latex(H))
except:
 _st_.goboom(30)
_st_.blockbegin()
try:
 G=CyclicPermutationGroup(4)
 C=G.cayley_graph(generators=[G((1,2,3,4)), G((1,4,3,2))])
 C.set_pos(C.layout_circular())
 C.set_latex_options(graphic_size=(8,6),vertex_shape="rectangle",
 edge_labels=True)
except:
 _st_.goboom(8)
_st_.blockend()
try:
 _st_.inline(11, latex(C))
except:
 _st_.goboom(10)
_st_.blockbegin()
try:
 var('x,y,n')
 funcs=[x^2, x^n, sin(x),cos(x)]
 table=r"\begin{table}  \centering  \begin{tabular}{cc}"
 table+=r"$f(x)$ & $f'(x)$ \\\hline"
 for f in funcs:
     table+=r"$%s$ & $%s$ \\"%(latex(f), latex(diff(f,x)))
 table+=r"\end{tabular}\end{table}"
except:
 _st_.goboom(25)
_st_.blockend()
try:
 _st_.inline(12, table)
except:
 _st_.goboom(26)
_st_.endofdoc()
