(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51420,       1263]
NotebookOptionsPosition[     48897,       1177]
NotebookOutlinePosition[     49235,       1192]
CellTagsIndexPosition[     49192,       1189]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"SetDirectory", "[", 
  "\"\<C:\\\\0000math\\\\CompleteWorks\\\\NigriniBenford\\\\\
DetectingDataFraud\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"firstdigit", "[", 
    RowBox[{"x_", ",", "b_"}], "]"}], " ", ":=", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{"b", "^", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"b", ",", "x"}], "]"}], ",", "1"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"firsttwodigit", "[", 
    RowBox[{"x_", ",", "b_"}], "]"}], " ", ":=", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{"b", "^", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"b", ",", "x"}], "]"}], ",", "1"}], "]"}]}], ")"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4098426582072144`*^9, 3.4098427586187563`*^9}, {
  3.4098432932232113`*^9, 3.4098432954261956`*^9}, {3.433697652329607*^9, 
  3.4336976579760237`*^9}, {3.4336984310375*^9, 3.433698433259527*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "::", "\<\"cdir\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Cannot set current directory to \
\\!\\(\\\"C:\\\\\\\\0000math\\\\\\\\CompleteWorks\\\\\\\\NigriniBenford\\\\\\\
\\DetectingDataFraud\\\"\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/cdir\\\", ButtonNote -> \
\\\"SetDirectory::cdir\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.41799759372431*^9, 3.433696613116757*^9, 
  3.433697658981228*^9}],

Cell[BoxData["$Failed"], "Output",
 CellChangeTimes->{3.4098432962288785`*^9, 3.4099111791637354`*^9, 
  3.4100046848974113`*^9, 3.4101790698617544`*^9, 3.4120761221465116`*^9, 
  3.413461648406474*^9, 3.4134617421399083`*^9, 3.4179975937555923`*^9, 
  3.433696613118886*^9, 3.4336976589835*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "REMINDER", " ", "ON", " ", "HOW", " ", "TO", " ", "SAVE", " ", "AND", " ",
     "READ", " ", "FILES"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"templist", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", " ", "=", " ", "1"}], ",", " ", 
     RowBox[{"i", " ", "\[LessEqual]", " ", "1000"}], ",", " ", 
     RowBox[{"i", "++"}], ",", " ", 
     RowBox[{
      RowBox[{"templist", " ", "=", " ", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"templist", ",", " ", 
         RowBox[{
          RowBox[{"2", "^", "i"}], " ", "*", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", " ", "+", " ", 
             RowBox[{"0", "*", 
              RowBox[{"Prime", "[", "i", "]"}], " ", "*", " ", 
              RowBox[{"i", "^", "2"}], " ", "*", " ", 
              RowBox[{"Cos", "[", "i", "]"}], " ", "*", " ", 
              RowBox[{"Cos", "[", "i", "]"}], " ", "*", " ", 
              RowBox[{"Sqrt", "[", "i", "]"}]}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"1", "/", "100"}], ")"}]}]}]}], "]"}]}], ";"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"readlist", " ", "=", " ", 
     RowBox[{"{", "2", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Put", "[", 
     RowBox[{"templist", ",", "\"\<pleaseworksave2\>\""}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"readlist", " ", "=", " ", 
     RowBox[{"Get", "[", "\"\<pleaseworksave2\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"Length", "[", "readlist", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.409842921388612*^9, 3.409842923226385*^9}, 
   3.40984301438266*^9, {3.409843323067981*^9, 3.4098433685543275`*^9}, {
   3.4099111867355165`*^9, 3.409911248966885*^9}, {3.4099112884126024`*^9, 
   3.4099113177974405`*^9}, {3.409912308106127*^9, 3.4099123215261664`*^9}, {
   3.41000468750076*^9, 3.4100046894801254`*^9}, 3.4100047303505564`*^9, 
   3.4100048440854645`*^9}],

Cell[BoxData["1000"], "Print",
 CellChangeTimes->{3.4099113194164777`*^9, 3.409912323989876*^9, 
  3.410004695812728*^9, 3.4100047432540274`*^9, 3.410004782914575*^9, 
  3.410004844877406*^9, 3.410179071093121*^9, 3.4120761239042115`*^9, 
  3.413461649622216*^9, 3.413461742978722*^9, 3.4179975940983458`*^9, 
  3.433696613282838*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DigitChecker", "[", 
    RowBox[{"datalist_", ",", "b_"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "initializes", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "we", " ", "take", " ", "absolute", " ", "values", " ", "of", " ", 
       "data"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"datasize", " ", "=", " ", 
       RowBox[{"Length", "[", "datalist", "]"}]}], ";", "\[IndentingNewLine]",
       
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", " ", "=", " ", "1"}], ",", " ", 
        RowBox[{"i", " ", "\[LessEqual]", " ", 
         RowBox[{"b", "-", "1"}]}], ",", " ", 
        RowBox[{"i", "++"}], ",", " ", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"firstdigitarray", "[", "i", "]"}], " ", "=", " ", "0"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"firstdigitbenf", "[", "i", "]"}], " ", "=", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"b", ",", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"i", "+", "1.0"}], ")"}], "/", "i"}]}], "]"}]}], ";"}],
          "\[IndentingNewLine]", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", " ", "=", " ", "b"}], ",", " ", 
        RowBox[{"i", " ", "\[LessEqual]", " ", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", "1"}]}], ",", " ", 
        RowBox[{"i", "++"}], ",", " ", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"firsttwodigitarray", "[", "i", "]"}], " ", "=", " ", 
           "0"}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"firsttwodigitbenf", "[", "i", "]"}], " ", "=", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"b", ",", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"i", "+", "1.0"}], ")"}], " ", "/", " ", "i"}]}], 
            "]"}]}], ";"}], "\[IndentingNewLine]", "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "reads", " ", "in", " ", "data", " ", "and", " ", "finds", " ", 
        "first", " ", 
        RowBox[{"digit", " ", "/", " ", "first"}], " ", "two", " ", 
        "digits"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"n", " ", "=", " ", "1"}], ",", " ", 
        RowBox[{"n", " ", "\[LessEqual]", " ", "datasize"}], ",", " ", 
        RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"w", " ", "=", " ", 
           RowBox[{"Abs", "[", 
            RowBox[{"datalist", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"x", " ", "=", " ", 
           RowBox[{"firstdigit", "[", 
            RowBox[{"w", ",", "b"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"y", " ", "=", " ", 
           RowBox[{"firsttwodigit", "[", 
            RowBox[{"w", ",", "b"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"firstdigitarray", "[", "x", "]"}], " ", "=", " ", 
           RowBox[{
            RowBox[{"firstdigitarray", "[", "x", "]"}], "+", "1"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"firsttwodigitarray", "[", "y", "]"}], " ", "=", " ", 
           RowBox[{
            RowBox[{"firsttwodigitarray", "[", "y", "]"}], "+", "1"}]}], 
          ";"}], "\[IndentingNewLine]", "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"plotfirstdigit", " ", "=", " ", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"plotfirstdigitbenf", " ", "=", " ", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"plotfirsttwodigit", " ", "=", " ", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"plotfirsttwodigitbenf", " ", "=", " ", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", " ", "=", " ", "1"}], ",", " ", 
        RowBox[{"i", " ", "\[LessEqual]", " ", 
         RowBox[{"b", "-", "1"}]}], ",", " ", 
        RowBox[{"i", "++"}], ",", " ", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", " ", 
         RowBox[{
          RowBox[{"plotfirstdigit", " ", "=", " ", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"plotfirstdigit", ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{
                RowBox[{"firstdigitarray", "[", "i", "]"}], " ", "/", " ", 
                "datasize"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          
          RowBox[{"plotfirstdigitbenf", " ", "=", " ", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"plotfirstdigitbenf", ",", " ", 
             RowBox[{"{", 
              RowBox[{"i", ",", " ", 
               RowBox[{"firstdigitbenf", "[", "i", "]"}]}], "}"}]}], "]"}]}], 
          ";"}], "\[IndentingNewLine]", "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", " ", "=", " ", "b"}], ",", " ", 
        RowBox[{"i", " ", "\[LessEqual]", " ", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", "1"}]}], ",", " ", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", " ", 
         RowBox[{
          RowBox[{"plotfirsttwodigit", " ", "=", " ", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"plotfirsttwodigit", ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{
                RowBox[{"firsttwodigitarray", "[", "i", "]"}], " ", "/", " ", 
                "datasize"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          
          RowBox[{"plotfirsttwodigitbenf", " ", "=", " ", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"plotfirsttwodigitbenf", ",", " ", 
             RowBox[{"{", 
              RowBox[{"i", ",", " ", 
               RowBox[{"firsttwodigitbenf", "[", "i", "]"}]}], "}"}]}], 
            "]"}]}], ";"}], "\[IndentingNewLine]", "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
      "Print", "[", 
       "\"\<Plot of first digit frequencies versus Benford's Law.\>\"", "]"}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"ListPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"plotfirstdigit", ",", " ", "plotfirstdigitbenf"}], "}"}], 
         ",", 
         RowBox[{"Joined", "\[Rule]", "True"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
      "Print", "[", 
       "\"\<Plot of first two digit frequencies versus Benford's Law.\>\"", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"ListPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"plotfirsttwodigit", ",", " ", "plotfirsttwodigitbenf"}], 
          "}"}], ",", 
         RowBox[{"Joined", "\[Rule]", "True"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"b", " ", "\[Equal]", " ", "10"}], ",", "\[IndentingNewLine]",
         
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"firstchi5", " ", "=", " ", "15.5073"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"firstchi1", " ", "=", " ", "20.0902"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"firsttwochi5", " ", "=", "  ", "112.0219"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"firsttwochi1", " ", "=", " ", "122.9422"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
          "Print", "[", "\"\<Chisqure tests on data, base 10.\>\"", "]"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<5% threshold (8 d.f.) is \>\"", ",", " ", "firstchi5", ",", 
            " ", "\"\<, at 1% is \>\"", " ", ",", " ", "firstchi1", ",", 
            "\"\<.\>\""}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"firstchi", " ", "=", " ", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"datasize", "*", 
                  RowBox[{"firstdigitbenf", "[", "i", "]"}]}], " ", "-", " ", 
                 
                 RowBox[{"firstdigitarray", "[", "i", "]"}]}], ")"}], "^", 
               "2"}], " ", "/", " ", 
              RowBox[{"(", 
               RowBox[{"datasize", "*", 
                RowBox[{"firstdigitbenf", "[", "i", "]"}]}], ")"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", 
               RowBox[{"b", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<Observed chisquare is \>\"", ",", " ", "firstchi", ",", " ", 
            "\"\<.\>\""}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<5% threshold (89 d.f.) is \>\"", ",", " ", "firsttwochi5", 
            ",", " ", "\"\<, at 1% is \>\"", " ", ",", " ", "firsttwochi1", 
            ",", "\"\<.\>\""}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"firsttwochi", " ", "=", " ", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"datasize", "*", 
                  RowBox[{"firsttwodigitbenf", "[", "i", "]"}]}], " ", "-", 
                 " ", 
                 RowBox[{"firsttwodigitarray", "[", "i", "]"}]}], ")"}], "^", 
               "2"}], " ", "/", " ", 
              RowBox[{"(", 
               RowBox[{"datasize", "*", 
                RowBox[{"firsttwodigitbenf", "[", "i", "]"}]}], ")"}]}], ",", 
             
             RowBox[{"{", 
              RowBox[{"i", ",", "b", ",", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "-", "1"}]}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<Observed chisquare is \>\"", ",", " ", "firsttwochi", ",", 
            " ", "\"\<.\>\""}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
          "Print", "[", "\"\<Testing goodness of fits to Benford's Law.\>\"", 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"firstchi", " ", "\[LessEqual]", "  ", "firstchi5"}], " ",
             ",", " ", 
            RowBox[{
            "Print", "[", 
             "\"\<Nothing significant at the 1% or 5% level.\>\"", "]"}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"firstchi", " ", ">", " ", "firstchi5"}], " ", "&&", " ",
              
             RowBox[{"firstchi", " ", "\[LessEqual]", "  ", "firstchi1"}]}], 
            ",", " ", 
            RowBox[{
            "Print", "[", 
             "\"\<Nothing significant at the 1% but something significant at \
the 5% level.\>\"", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"firsttwochi", " ", ">", " ", "firsttwochi1"}], ",", " ", 
            
            RowBox[{
            "Print", "[", 
             "\"\<Significant difference found at the 1% and 5% levels.\>\"", 
             "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
            "firsttwochi", " ", "\[LessEqual]", "  ", "firsttwochi5"}], " ", 
            ",", " ", 
            RowBox[{
            "Print", "[", 
             "\"\<Nothing significant at the 1% or 5% level.\>\"", "]"}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"firsttwochi", " ", ">", " ", "firsttwochi5"}], " ", "&&",
              " ", 
             RowBox[{
             "firsttwochi", " ", "\[LessEqual]", "  ", "firsttwochi1"}]}], 
            ",", " ", 
            RowBox[{
            "Print", "[", 
             "\"\<Nothing significant at the 1% but something significant at \
the 5% level.\>\"", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"firsttwochi", " ", ">", " ", "firsttwochi1"}], ",", " ", 
            
            RowBox[{
            "Print", "[", 
             "\"\<Significant difference found at the 1% and 5% levels.\>\"", 
             "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", "}"}]}], "]"}], 
      ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"end", " ", "of", " ", "base", " ", "10"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"b", " ", "\[NotEqual]", " ", "10"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"fmlist", " ", "=", " ", 
           RowBox[{"FindMinimum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"CDF", "[", 
                 RowBox[{
                  RowBox[{"ChiSquareDistribution", "[", 
                   RowBox[{"b", "-", "1"}], "]"}], ",", "q"}], "]"}], " ", 
                "-", " ", ".97"}], ")"}], "^", "2"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"q", ",", "2"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"q", " ", "/.", " ", "%"}], ";", "\[IndentingNewLine]", 
            RowBox[{"gg", " ", "=", " ", "%"}], ";", "\[IndentingNewLine]", 
            RowBox[{"Print", "[", "gg", "]"}], ";"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"firstchi5", " ", "=", " ", "15.5073"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"firstchi1", " ", "=", " ", "20.0902"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"firsttwochi5", " ", "=", "  ", "112.0219"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"firsttwochi1", " ", "=", " ", "122.9422"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
          "Print", "[", "\"\<Chisqure tests on data, base 10.\>\"", "]"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<5% threshold (8 d.f.) is \>\"", ",", " ", "firstchi5", ",", 
            " ", "\"\<, at 1% is \>\"", " ", ",", " ", "firstchi1", ",", 
            "\"\<.\>\""}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"firstchi", " ", "=", " ", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"datasize", "*", 
                  RowBox[{"firstdigitbenf", "[", "i", "]"}]}], " ", "-", " ", 
                 
                 RowBox[{"firstdigitarray", "[", "i", "]"}]}], ")"}], "^", 
               "2"}], " ", "/", " ", 
              RowBox[{"(", 
               RowBox[{"datasize", "*", 
                RowBox[{"firstdigitbenf", "[", "i", "]"}]}], ")"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", 
               RowBox[{"b", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<Observed chisquare is \>\"", ",", " ", "firstchi", ",", " ", 
            "\"\<.\>\""}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<5% threshold (89 d.f.) is \>\"", ",", " ", "firsttwochi5", 
            ",", " ", "\"\<, at 1% is \>\"", " ", ",", " ", "firsttwochi1", 
            ",", "\"\<.\>\""}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"firsttwochi", " ", "=", " ", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"datasize", "*", 
                  RowBox[{"firsttwodigitbenf", "[", "i", "]"}]}], " ", "-", 
                 " ", 
                 RowBox[{"firsttwodigitarray", "[", "i", "]"}]}], ")"}], "^", 
               "2"}], " ", "/", " ", 
              RowBox[{"(", 
               RowBox[{"datasize", "*", 
                RowBox[{"firsttwodigitbenf", "[", "i", "]"}]}], ")"}]}], ",", 
             
             RowBox[{"{", 
              RowBox[{"i", ",", "b", ",", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "-", "1"}]}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<Observed chisquare is \>\"", ",", " ", "firsttwochi", ",", 
            " ", "\"\<.\>\""}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
          "Print", "[", "\"\<Testing goodness of fits to Benford's Law.\>\"", 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"firstchi", " ", "\[LessEqual]", "  ", "firstchi5"}], " ",
             ",", " ", 
            RowBox[{
            "Print", "[", 
             "\"\<Nothing significant at the 1% or 5% level.\>\"", "]"}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"firstchi", " ", ">", " ", "firstchi5"}], " ", "&&", " ",
              
             RowBox[{"firstchi", " ", "\[LessEqual]", "  ", "firstchi1"}]}], 
            ",", " ", 
            RowBox[{
            "Print", "[", 
             "\"\<Nothing significant at the 1% but something significant at \
the 5% level.\>\"", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"firsttwochi", " ", ">", " ", "firsttwochi1"}], ",", " ", 
            
            RowBox[{
            "Print", "[", 
             "\"\<Significant difference found at the 1% and 5% levels.\>\"", 
             "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
            "firsttwochi", " ", "\[LessEqual]", "  ", "firsttwochi5"}], " ", 
            ",", " ", 
            RowBox[{
            "Print", "[", 
             "\"\<Nothing significant at the 1% or 5% level.\>\"", "]"}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"firsttwochi", " ", ">", " ", "firsttwochi5"}], " ", "&&",
              " ", 
             RowBox[{
             "firsttwochi", " ", "\[LessEqual]", "  ", "firsttwochi1"}]}], 
            ",", " ", 
            RowBox[{
            "Print", "[", 
             "\"\<Nothing significant at the 1% but something significant at \
the 5% level.\>\"", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"firsttwochi", " ", ">", " ", "firsttwochi1"}], ",", " ", 
            
            RowBox[{
            "Print", "[", 
             "\"\<Significant difference found at the 1% and 5% levels.\>\"", 
             "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", "}"}]}], "]"}], 
      ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4099113322672176`*^9, 3.40991178300497*^9}, {
  3.4099118235209312`*^9, 3.4099119785754604`*^9}, {3.409912033453784*^9, 
  3.4099120442968397`*^9}, {3.4099120984037285`*^9, 3.409912108087679*^9}, {
  3.4099122579403925`*^9, 3.4099122855675306`*^9}, {3.409912346531402*^9, 
  3.4099124817620044`*^9}, {3.409912756727804*^9, 3.40991278592906*^9}, {
  3.409912818238516*^9, 3.4099129866203165`*^9}, {3.4099130258443685`*^9, 
  3.4099130441459312`*^9}, {3.409913094820422*^9, 3.4099133097285423`*^9}, {
  3.40991336263043*^9, 3.4099135335794497`*^9}, {3.4101799174266477`*^9, 
  3.4101799715452538`*^9}, {3.410180295520612*^9, 3.4101804165187273`*^9}, {
  3.4134621166921077`*^9, 3.413462146772214*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tempdata", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "64", ",", 
     "128", ",", "256", ",", "512", ",", "1024"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"DigitChecker", "[", 
  RowBox[{"readlist", ",", "10"}], "]"}]}], "Input",
 CellChangeTimes->{{3.409911982514662*^9, 3.4099120257257633`*^9}, {
  3.4099121226697536`*^9, 3.4099121233825984`*^9}, {3.410180392436284*^9, 
  3.410180406272312*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Plot of first digit frequencies versus Benford's \
Law.\"\>"], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.433696613515256*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 0.301}, {2., 0.176}, {3., 0.125}, {4., 0.097}, {5., 
     0.079}, {6., 0.069}, {7., 0.056}, {8., 0.052}, {9., 0.045}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    LineBox[{{1., 0.30102999566398114`}, {2., 0.17609125905568124`}, {3., 
     0.1249387366082999}, {4., 0.0969100130080564}, {5., 
     0.07918124604762489}, {6., 0.06694678963061312}, {7., 
     0.057991946977686726`}, {8., 0.051152522447381284`}, {9., 
     0.04575749056067514}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.05},
  PlotRange->{{0., 9.}, {0.045, 0.30102999566398114`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.433696613656764*^9}],

Cell[BoxData["\<\"Plot of first two digit frequencies versus Benford's Law.\"\
\>"], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.433696613661003*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd0csrhFEYBvC3ycLC0sJKlCYhGXcGc2YMY5iLGXPLUpQskCa5pZPcEuUW
FlNioZRkYSFJ38LC2j8gS7GxlQVjHuk8U1/Tr+c833u+c0qHJqIjNhEZ/Hmy
/7lfmRq7S+8V5Z25crYr53N463D8FC5X75Gb4pW3E7hCZR5KrqZG/1ylZl/t
jvyLDFxNriE71OdiduIRXKsGh38nwnXq1l9gq1w7gOspb1DzhZe+l7l9uBH7
3YWbyM3kFux/B26l3Km+zj+egkPbcBv2vwm3kzvILrIyrcniVi3Xj9P3xxvI
3fj+VeQe09qD81tH3kk5Wbzmeu2lvAvnuYycLN04nyXkZPFR34fz08h7qE8W
v7le+ynvpT5Z+qhPlgC+fwZ5gPIg7mMBOVlC9P6Q+T4JU58s/aYVWZMtskTM
eSpCfcqtCO4jjX6U+lEz15RbZBmg/gD1yRatl5iZqxjtn3IrRv049ck6jvuZ
RD9O/YSZqwT1yRatlyTNJ+skzSdLiuanqE+59Z9/A1LTnFc=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJw1ywlMk3ccxvFXCEdgAjIzVkfGuiyjMgZCgcohPCJnoVBKaWsrDA3MKjo5
NkS08CpVQMB2gIQpAsJQJCuemZ2Y8JpJBkJ0brIwsgMC1GXOpCZMAY8d6a//
5Jd/Pvnm4e/YJyt0YBhG/d/9/9vee/jJ9KbbnpC+OJvfx6qe3CtOW3vJAriv
uA8pJs6SA7Ba7DxypLKbHAjX9sVZ02AnOQjTw1MThqsd5A3wtDAfLP99ihyC
kWXvw+qiL8ihMMy/HNjr3k4WYlzj0tB1r40cholkvzt9V06SwzH2urc49FIr
OQLCgknXodstZBHu/b6gkT5uJm9ECRu4S+dvdyS6yh69tqHkc3IUhh89Dz83
aiRHQ9zvJf8o0O4YbCvsvsiPMJA3YfBOytoo/xPkWGwVRu7wCWgix2FjeoXI
dVMjGTCILp8w5jXYzAJ1rdLvtjcdp74Z6tsnveSj9dQ3YyXI+CTfg8zEw4pt
1zvz6qjHI7KuqzPGXEt9Cxz8wtqq15HZLdjVPl09rD9GPQEHv/L/ueDpUeoJ
EM29MWT5hMwkIq/oOX/ssZ56IqQ3BaWnS8lMEjSuI8HPXtRQT4KQW5itaiQz
yRBnlqz79R17T8b6YvWZb785Qj0F2vzBnj8VZDYFzd0DwV5Lh6mnwne8v+ZZ
B5lNhYdvUJs20d7FaKyc7A1+wlIXY1Xuu6O+3WQmDfqllh5Hmb2nYU7Z5DTk
bO/pGLde00QeqqaeDsF0g6ObtYq6BH/UDJr6tGRWAp81c5V3F3TUM6C1JveK
d5LZDBSXB/Dn/zpEPRP+ZrcCbTmZzUTEzIJbv6O9S+Fx/8WX5a0HbYYUT88U
VgwIyKwUGm5c4stV2sxJcV87ifNqMpOF/p3XWgVLB2ifhST+/sbqdjKbBb3w
RlJTNJnLgi7g446w2QrayxBh+dBBXU+GDL+cPr5nTkhmZfBnl8PNM/tpL0OG
MdHlloHMZMO7ynTrIcjIhoS7sdtnsZz22Xjo18uLuUDmssFf422JzyczctzU
RU3xeGTI8XJ67fTFHz+jvRwPmEsXFg1kTo7fRnQTUxIykwPPA8dqJKvJyIEp
t5hLuPsp7XPgu5j61mUjmcvBgN5l7KiczCiQZ+5r/ppHhgJnVfMTopky2isQ
XtwkfXWezCkQ6hVb9k8xmVFiznKOCYkmQwkHc3RYvbN9r8T2stSrr34opb0S
6XuLauu6yYwKQd+reG/vI0OF3VbHwOuxZFaFFZPTVJqnfa+CR0tm7YOZkrh/
AVltkh8=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.005},
  PlotRange->{{0., 99.}, {0.004, 0.043}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.433696613662525*^9}],

Cell[BoxData["\<\"Chisqure tests on data, base 10.\"\>"], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.433696613666039*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"5% threshold (8 d.f.) is \"\>", "\[InvisibleSpace]", 
   "15.5073`", "\[InvisibleSpace]", "\<\", at 1% is \"\>", 
   "\[InvisibleSpace]", "20.0902`", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "5% threshold (8 d.f.) is ", 15.5073, ", at 1% is ", 20.0902, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.4336966136673927`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Observed chisquare is \"\>", "\[InvisibleSpace]", 
   "0.15855057629205024`", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Observed chisquare is ", 0.15855057629205024`, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.433696613668771*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.4336966136701*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"5% threshold (89 d.f.) is \"\>", "\[InvisibleSpace]", 
   "112.0219`", "\[InvisibleSpace]", "\<\", at 1% is \"\>", 
   "\[InvisibleSpace]", "122.9422`", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "5% threshold (89 d.f.) is ", 112.0219, ", at 1% is ", 122.9422, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.433696613671424*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Observed chisquare is \"\>", "\[InvisibleSpace]", 
   "5.457575486438758`", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Observed chisquare is ", 5.457575486438758, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.433696613672798*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.433696613674109*^9}],

Cell[BoxData["\<\"Testing goodness of fits to Benford's Law.\"\>"], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.4336966136753693`*^9}],

Cell[BoxData["\<\"Nothing significant at the 1% or 5% level.\"\>"], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.4336966136767073`*^9}],

Cell[BoxData["\<\"Nothing significant at the 1% or 5% level.\"\>"], "Print",
 CellChangeTimes->{
  3.4099120464275627`*^9, {3.409912100920169*^9, 3.4099121252984915`*^9}, {
   3.4099122616842937`*^9, 3.4099122799829273`*^9}, 3.409912328350925*^9, 
   3.4099123745462103`*^9, 3.4099124389727507`*^9, 3.409912485640662*^9, 
   3.409913050230503*^9, {3.4099135109676156`*^9, 3.4099135370655546`*^9}, 
   3.4100047017088346`*^9, 3.4100047905996304`*^9, 3.4100048470344944`*^9, 
   3.4101790746866407`*^9, 3.4101803934889507`*^9, 3.412076134414281*^9, 
   3.413461652474573*^9, 3.4134617450459723`*^9, 3.417997594480207*^9, 
   3.433696613678032*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.409912750474298*^9, 3.4099127530405397`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "x", "]"}], ";", " ", 
  RowBox[{"Clear", "[", "y", "]"}], ";", " ", 
  RowBox[{"Clear", "[", "n", "]"}], ";", " ", 
  RowBox[{"Clear", "[", "w", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"chisq", "[", 
   RowBox[{"x_", ",", "r_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"r", "/", "2"}], " ", "-", " ", "1"}], ")"}]}], " ", "*", " ", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "x"}], "/", "2"}], "]"}], " ", "/", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "^", 
       RowBox[{"(", 
        RowBox[{"r", "/", "2"}], ")"}]}], " ", "*", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"r", "/", "2"}], "]"}]}], ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"chisq", "[", 
    RowBox[{"y", ",", "n"}], "]"}], ",", " ", "y"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"chisq", "[", 
    RowBox[{"y", ",", "5"}], "]"}], ",", " ", "y"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"chisq", "[", 
    RowBox[{"y", ",", "6"}], "]"}], ",", " ", "y"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cdfchisq", "[", 
   RowBox[{"x_", ",", "r_"}], "]"}], " ", ":=", " ", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["r", "2"], ",", 
      FractionBox["x", "2"]}], "]"}], 
    RowBox[{"Gamma", "[", 
     FractionBox["r", "2"], "]"}]]}]}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"cdfchisq", "[", 
      RowBox[{"w", ",", "9"}], "]"}], " ", "-", " ", 
     RowBox[{"cdfchisq", "[", 
      RowBox[{"0.", ",", "9"}], "]"}]}], " ", "\[Equal]", " ", ".95"}], ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"w", ",", "10"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", "w"}], "Input",
 CellChangeTimes->{{3.4101792017322206`*^9, 3.4101794242843823`*^9}, {
  3.410179470911281*^9, 3.4101795029707527`*^9}, {3.410180700186118*^9, 
  3.4101809332405376`*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["n", "2"], ",", 
     FractionBox["y", "2"]}], "]"}], 
   RowBox[{"Gamma", "[", 
    FractionBox["n", "2"], "]"}]]}]], "Output",
 CellChangeTimes->{{3.4101792821352777`*^9, 3.410179424705254*^9}, {
   3.4101794828275104`*^9, 3.410179503665044*^9}, {3.4101807010366497`*^9, 
   3.4101807343255343`*^9}, {3.410180795234722*^9, 3.4101809338811216`*^9}, 
   3.4134616554402037`*^9, 3.417997596230639*^9, 3.433696614178327*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "y"}], "/", "2"}]], " ", 
    SqrtBox["y"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", "y"}], ")"}]}], "+", 
   RowBox[{"3", " ", 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]], " ", 
    RowBox[{"Erf", "[", 
     FractionBox[
      SqrtBox["y"], 
      SqrtBox["2"]], "]"}]}]}], 
  RowBox[{"3", " ", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]]}]]], "Output",
 CellChangeTimes->{{3.4101792821352777`*^9, 3.410179424705254*^9}, {
   3.4101794828275104`*^9, 3.410179503665044*^9}, {3.4101807010366497`*^9, 
   3.4101807343255343`*^9}, {3.410180795234722*^9, 3.4101809338811216`*^9}, 
   3.4134616554402037`*^9, 3.417997596230639*^9, 3.4336966142226143`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "y"}], "/", "2"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "16"}], "-", 
    RowBox[{"8", " ", "y"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["y", "2"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.4101792821352777`*^9, 3.410179424705254*^9}, {
   3.4101794828275104`*^9, 3.410179503665044*^9}, {3.4101807010366497`*^9, 
   3.4101807343255343`*^9}, {3.410180795234722*^9, 3.4101809338811216`*^9}, 
   3.4134616554402037`*^9, 3.417997596230639*^9, 3.43369661426339*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"w", "\[Rule]", "16.918977604620434`"}], "}"}]], "Output",
 CellChangeTimes->{{3.4101792821352777`*^9, 3.410179424705254*^9}, {
   3.4101794828275104`*^9, 3.410179503665044*^9}, {3.4101807010366497`*^9, 
   3.4101807343255343`*^9}, {3.410180795234722*^9, 3.4101809338811216`*^9}, 
   3.4134616554402037`*^9, 3.417997596230639*^9, 3.4336966143269157`*^9}],

Cell[BoxData["w"], "Output",
 CellChangeTimes->{{3.4101792821352777`*^9, 3.410179424705254*^9}, {
   3.4101794828275104`*^9, 3.410179503665044*^9}, {3.4101807010366497`*^9, 
   3.4101807343255343`*^9}, {3.410180795234722*^9, 3.4101809338811216`*^9}, 
   3.4134616554402037`*^9, 3.417997596230639*^9, 3.433696614328484*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", "5", "]"}]], "Input",
 CellChangeTimes->{{3.4101792541233983`*^9, 3.410179261976412*^9}}],

Cell[BoxData["24"], "Output",
 CellChangeTimes->{{3.410179257471817*^9, 3.4101792623084216`*^9}, 
   3.4179975969935713`*^9, 3.4336966144058313`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"CDF", "[", 
       RowBox[{
        RowBox[{"StudentTDistribution", "[", "20.", "]"}], ",", "q"}], "]"}], 
      " ", "-", " ", ".97"}], ")"}], "^", "2"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"q", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4101796868808565`*^9, 3.4101797037743063`*^9}, {
  3.4101797681920586`*^9, 3.410179833075601*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.8113000673787006`*^-21", ",", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", "1.993712607268327`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.4101796970266914`*^9, 3.4101797046355796`*^9}, {
   3.4101797740315285`*^9, 3.41017983384313*^9}, 3.41799759716547*^9, 
   3.4336966144544373`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fmlist", " ", "=", " ", 
  RowBox[{"FindMinimum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"CDF", "[", 
        RowBox[{
         RowBox[{"ChiSquareDistribution", "[", "10", "]"}], ",", "q"}], "]"}],
        " ", "-", " ", ".97"}], ")"}], "^", "2"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"q", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4101798661311026`*^9, 3.4101798928637667`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0009000000000000018`", ",", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", "128.08567416701896`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.4101798769390044`*^9, 3.4101798936644964`*^9}, {
   3.410180240362033*^9, 3.4101802563151135`*^9}, 3.4101803482818837`*^9, 
   3.417997597228435*^9, 3.433696614487278*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["fmlist"], "Input",
 CellChangeTimes->{{3.410179894468156*^9, 3.4101798951546354`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0009000000000000018`", ",", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", "128.08567416701896`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{3.417997597272623*^9, 3.433696614521633*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["q"], "Input",
 CellChangeTimes->{3.41018035336066*^9}],

Cell[BoxData["q"], "Output",
 CellChangeTimes->{
  3.410179895778619*^9, 3.4101802577476387`*^9, {3.4101803493677516`*^9, 
   3.4101803538108263`*^9}, 3.417997597311503*^9, 3.4336966145550013`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fmlist", "[", 
   RowBox[{"[", "2", "]"}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.410179898128078*^9, 3.4101798998682013`*^9}, {
  3.410180075579611*^9, 3.4101800976221457`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"q", "\[Rule]", "128.08567416701896`"}], "}"}]], "Output",
 CellChangeTimes->{3.410180098187539*^9, 3.410180259117668*^9, 
  3.417997597408646*^9, 3.4336966145869217`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"q", " ", "/.", " ", "%"}]}]], "Input",
 CellChangeTimes->{{3.410180086764442*^9, 3.410180086979272*^9}, {
  3.4101802122495747`*^9, 3.410180253730318*^9}}],

Cell[BoxData["128.08567416701896`"], "Output",
 CellChangeTimes->{
  3.410180087371825*^9, {3.4101802165305505`*^9, 3.4101802600746384`*^9}, 
   3.417997597496108*^9, 3.433696614621009*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ggg", " ", "=", "  ", "%"}]], "Input",
 CellChangeTimes->{{3.4101802489962463`*^9, 3.4101802724537287`*^9}}],

Cell[BoxData["128.08567416701896`"], "Output",
 CellChangeTimes->{3.410180273121655*^9, 3.4179975975456133`*^9, 
  3.433696614654653*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "ggg", "]"}]], "Input",
 CellChangeTimes->{{3.410180275236754*^9, 3.4101802769251223`*^9}}],

Cell[BoxData["128.08567416701896`"], "Print",
 CellChangeTimes->{3.410180277420208*^9, 3.417997597592635*^9, 
  3.433696614687108*^9}]
}, Open  ]]
},
WindowSize->{1036, 683},
WindowMargins->{{276, Automatic}, {Automatic, 21}},
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1092, 30, 58, "Input"],
Cell[1685, 55, 556, 11, 23, "Message"],
Cell[2244, 68, 295, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2576, 77, 2154, 51, 118, "Input"],
Cell[4733, 130, 334, 5, 20, "Print"]
}, Open  ]],
Cell[5082, 138, 21226, 487, 1558, "Input"],
Cell[CellGroupData[{
Cell[26333, 629, 518, 12, 43, "Input"],
Cell[CellGroupData[{
Cell[26876, 645, 658, 10, 20, "Print"],
Cell[27537, 657, 1353, 27, 228, "Print"],
Cell[28893, 686, 662, 10, 20, "Print"],
Cell[29558, 698, 2815, 53, 224, "Print"],
Cell[32376, 753, 635, 9, 20, "Print"],
Cell[33014, 764, 921, 16, 20, "Print"],
Cell[33938, 782, 830, 14, 20, "Print"],
Cell[34771, 798, 602, 9, 20, "Print"],
Cell[35376, 809, 925, 16, 20, "Print"],
Cell[36304, 827, 825, 14, 20, "Print"],
Cell[37132, 843, 604, 9, 20, "Print"],
Cell[37739, 854, 647, 9, 20, "Print"],
Cell[38389, 865, 647, 9, 20, "Print"],
Cell[39039, 876, 645, 9, 20, "Print"]
}, Open  ]]
}, Open  ]],
Cell[39711, 889, 94, 1, 27, "Input"],
Cell[CellGroupData[{
Cell[39830, 894, 2148, 65, 172, "Input"],
Cell[41981, 961, 522, 12, 61, "Output"],
Cell[42506, 975, 815, 24, 63, "Output"],
Cell[43324, 1001, 612, 15, 45, "Output"],
Cell[43939, 1018, 393, 6, 27, "Output"],
Cell[44335, 1026, 322, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44694, 1035, 126, 2, 27, "Input"],
Cell[44823, 1039, 149, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45009, 1046, 473, 13, 27, "Input"],
Cell[45485, 1061, 340, 8, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45862, 1074, 470, 13, 27, "Input"],
Cell[46335, 1089, 363, 8, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46735, 1102, 100, 1, 27, "Input"],
Cell[46838, 1105, 233, 6, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47108, 1116, 68, 1, 27, "Input"],
Cell[47179, 1119, 197, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47413, 1127, 220, 5, 27, "Input"],
Cell[47636, 1134, 210, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47883, 1143, 195, 4, 27, "Input"],
Cell[48081, 1149, 189, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48307, 1157, 132, 2, 27, "Input"],
Cell[48442, 1161, 137, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48616, 1168, 128, 2, 27, "Input"],
Cell[48747, 1172, 134, 2, 20, "Print"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
