/*** EXAMPLE: Dirichlet L-function of a quadratic character modulo odd P ***/
/*** v1.1, December 2003, questions to tim.dokchitser@durham.ac.uk       ***/
/***                                                                     ***/
/*** type \rex-chqua or read("ex-chqua") at pari prompt to run this      ***/

default(realprecision,28);        \\ set working precision; used throughout

P = 37;                     \\ May change this to to any other odd prime
                            \\ Chi = Legendre character modulo this P

                            \\ initialize L-function parameters
conductor = P;              \\ exponential factor
gammaV    = [P%4==3];   \\ [0] if P=1 mod 4 (even), [1] if 3 mod 4 (odd)
weight    = 1;              \\ L(s)=sgn*L(weight-s)
sgn       = 1;              \\ sign in the functional equation

aaa = (n->if(n%P,(-1)^((P-1)/znorder(Mod(n,P))),0));
  \\ coefficients: 1 for n square mod P, -1 for non-square, 0 for n=0 mod P
initall([conductor,gammaV,weight,sgn]);initLdata(aaa);
              \\ initialize L-function parameters

zinit     = zetakinit(nfinit(quadpoly(quaddisc(if(P%4==3,-P,P)))));
LPari(x)  = zetak(zinit,x)/zeta(x);
  \\ alternatively the same L-function is the Dedekind zeta function of
  \\ the maximal order of Q(sqrt(P)) (p=1 mod 4) or Q(sqrt(-P)) (p=3 mod 4)
  \\ divided by the Riemann zeta function

print("EXAMPLE: L(s)=L(Chi(P),s), Chi(P)=(Legendre) quadratic character modulo P");
print("         with ",default(realprecision)," digits precision");
print("         take P=",P);
print("Verifying functional equation. Error: ",errprint(checkfeq()));
print("L(Chi(P),2) = ",L(2));
print("  (pari)    = ",LPari(2));
print("L(Chi(P),I) = ",L(I));
print("  (pari)    = ",LPari(I));
