package ToyIP;

import ToyIP.*;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;


class InstanceConstraintsTableModel extends AbstractTableModel {

  protected AppletSettings app;
  protected String[] columnNames = { "Constraint #", "X", "Y", "Z", "", "RHS"};
  protected java.util.List< Double[] > data = new LinkedList< Double[] > ();

  public InstanceConstraintsTableModel(AppletSettings a) {
    app = a;
  }

  public int getColumnCount() {
    return columnNames.length;
  }

  public int getRowCount() {
    return data.size();
  }

  public String getColumnName(int col) {
    return columnNames[col];
  }

  public Object getValueAt(int row, int col) {
    if (col == 0) return row;
    if (col == 1) return data.get(row)[0];
    if (col == 2) return data.get(row)[1];
    if (col == 3) return data.get(row)[2];
    if (col == 4) return "<=";
    if (col == 5) return data.get(row)[3];
    return "";
  }

  public Class getColumnClass(int col) {
    if (col == 0) return Integer.class;
    if (col == 4) return String.class;
    return Double.class;
  }

  public boolean isCellEditable(int row, int col) {
    if (col == 0) return false;
    if (col == 4) return false;
    return true;
  }

  public void setValueAt(Object value, int row, int col) {
    Double d[] = data.get(row);
    if (col == 0) return;
    if (col == 1) d[0] = (Double) value;
    if (col == 2) d[1] = (Double) value;
    if (col == 3) d[2] = (Double) value;
    if (col == 4) return;
    if (col == 5) d[3] = (Double) value;
    data.set(row, d);
    fireTableDataChanged();
  }

  public void clear() {
    data.clear();
    fireTableDataChanged();
  }

  public void addLine(Double line[]) {
    data.add(line);
    fireTableDataChanged();
  }

  public java.util.List< Double[] > getData() {
    return data;
  }
}

