package ToyIP;

import ToyIP.*;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

import org.python.core.PyObject;
import org.python.util.PythonInterpreter;


public class GeneratorExecuteAction extends AbstractAction {

  protected AppletSettings app;

  public GeneratorExecuteAction(AppletSettings a) {
    super("Execute");
    app = a;
  }

  public void actionPerformed(ActionEvent ae) {
    String script = app.getScriptText();
    app.instanceReset();
    try {
      PythonInterpreter interp = new PythonInterpreter();
      interp.setOut(System.out);
      interp.setErr(System.err);
      interp.exec(script);
      PyObject ax = interp.get("ax");
      PyObject ay = interp.get("ay");
      PyObject az = interp.get("az");
      PyObject b = interp.get("b");
      if (! ( (ax.__len__() == ay.__len__()) && (ay.__len__() == az.__len__())  && (az.__len__() == b.__len__()))) {
        return;
      }
      for (int i = 0; i < ax.__len__(); i++) {
        Double axi = Double.valueOf(ax.__getitem__(i).toString());
        Double ayi = Double.valueOf(ay.__getitem__(i).toString());
        Double azi = Double.valueOf(az.__getitem__(i).toString());
        Double bi = Double.valueOf(b.__getitem__(i).toString());
        app.instanceAddConstraint(axi, ayi, azi, bi);
      }
    }
    catch (Exception e) {
      System.out.println(e.toString());
    }
    app.goToNextTab();
  }
}
